/*------------------------------------------------------------------------------*
 * File Name: CoreConcept.c														*
 * Creation: GJL 6/24/2003														*
 * Purpose: Origin C file containing GetNBox example codes.						*
 * Copyright (c) OriginLab Corp.	2003-2007									*
 * All Rights Reserved															*
 *------------------------------------------------------------------------------*/

#include <Origin.h>
#include <GetNBox.h>

void CoreConcept()
{
	// Use GETN_BOX macro to declare a tree for a Box style GetN dialog
	GETN_BOX(tr)

	// Use macro to add a checkbox node named UpperCase having caption
	// "Upper Case" initialized to false (unchecked)
	GETN_CHECK(UpperCase, "Upper Case", false)

	// Use macro to add a string edit box node named InputText having
	// caption "Enter Text" initialized to text value "Some sample text"
	GETN_STR(InputText, "Enter Text", "Some sample text")

	// Output GetNBox tree before editing input defaults
	out_tree(tr);

	// Open GetNBox dialog and edit input defaults passing GetN tree named tr
	// and having dialog title "Get Text"
	if( GetNBox(tr, "Get Text") ) // If user clicks OK button GetNBox function returns true
	{
		// Directly evaluate and manipulate GetN tree values 
		if( tr.UpperCase.nVal ) // If checkbox is checked
			tr.InputText.strVal.MakeUpper(); // Upper case string value
	}
	// Else if user clicks Cancel button GetNBox function returns false so do nothing

	// Output GetNBox tree after editing inputs in dialog and upper casing
	out_tree(tr);
}